package com.ejie.ab04b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.VdesestimadosOs2;

/**
 * VdesestimadosOs2DaoImpl generated by UDA, 04-ago-2017 12:51:36.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class VdesestimadosOs2DaoImpl implements VdesestimadosOs2Dao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<VdesestimadosOs2> rwMap = new RowMapper<VdesestimadosOs2>() {
		public VdesestimadosOs2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VdesestimadosOs2(resultSet.getString("ANOEXP"),
					resultSet.getString("TERRITEXP"),
					resultSet.getInt("NUMEXP"), resultSet.getDate("REQFECHA"));
		}
	};

	private RowMapper<VdesestimadosOs2> rwMapPK = new RowMapper<VdesestimadosOs2>() {
		public VdesestimadosOs2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VdesestimadosOs2(resultSet.getString("ANOEXP"),
					resultSet.getString("TERRITEXP"),
					resultSet.getInt("NUMEXP"), resultSet.getDate("REQFECHA"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * dataSource DataSource
	 * 
	 */
	private RowMapper<JerarquiaDto<VdesestimadosOs2>> rwMapJerarquia = new RowMapper<JerarquiaDto<VdesestimadosOs2>>() {
		public JerarquiaDto<VdesestimadosOs2> mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {

			VdesestimadosOs2 vdesestimadosos2 = new VdesestimadosOs2(
					resultSet.getString("ANOEXP"),
					resultSet.getString("TERRITEXP"),
					resultSet.getInt("NUMEXP"), resultSet.getDate("REQFECHA"));

			JerarquiaDto<VdesestimadosOs2> jerarquia = new JerarquiaDto<VdesestimadosOs2>();
			jerarquia.setModel(vdesestimadosos2);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(
					Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(
					Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 *
	 * @param dataSource
	 *            the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the VdesestimadosOs2 table.
	 * 
	 * vdesestimadosos2 VdesestimadosOs2 VdesestimadosOs2
	 *
	 * @param vdesestimadosos2
	 *            the vdesestimadosos 2
	 * @return the vdesestimados os 2
	 */
	public VdesestimadosOs2 add(VdesestimadosOs2 vdesestimadosos2) {
		String query = "INSERT INTO VDESESTIMADOS_OS2 (ANO_EXP, TERRIT_EXP, NUM_EXP, REQ_FECHA) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, vdesestimadosos2.getAnoExp(),
				vdesestimadosos2.getTerritExp(), vdesestimadosos2.getNumExp(),
				vdesestimadosos2.getReqFecha());
		return vdesestimadosos2;
	}

	/**
	 * Updates a single row in the VdesestimadosOs2 table.
	 * 
	 * vdesestimadosos2 VdesestimadosOs2 VdesestimadosOs2
	 *
	 * @param vdesestimadosos2
	 *            the vdesestimadosos 2
	 * @return the vdesestimados os 2
	 */
	public VdesestimadosOs2 update(VdesestimadosOs2 vdesestimadosos2) {
		String query = "UPDATE VDESESTIMADOS_OS2 SET  WHERE ANO_EXP=? AND TERRIT_EXP=? AND NUM_EXP=? AND REQ_FECHA=?";
		this.jdbcTemplate.update(query, vdesestimadosos2.getAnoExp(),
				vdesestimadosos2.getTerritExp(), vdesestimadosos2.getNumExp(),
				vdesestimadosos2.getReqFecha());
		return vdesestimadosos2;
	}

	/**
	 * Finds a single row in the VdesestimadosOs2 table.
	 * 
	 * vdesestimadosos2 VdesestimadosOs2 VdesestimadosOs2
	 *
	 * @param vdesestimadosos2
	 *            the vdesestimadosos 2
	 * @return the vdesestimados os 2
	 */
	@Transactional(readOnly = true)
	public VdesestimadosOs2 find(VdesestimadosOs2 vdesestimadosos2) {
		String query = "SELECT t1.ANO_EXP ANOEXP, t1.TERRIT_EXP TERRITEXP, t1.NUM_EXP NUMEXP, t1.REQ_FECHA REQFECHA FROM VDESESTIMADOS_OS2 t1  WHERE t1.ANO_EXP = ?   AND t1.TERRIT_EXP = ?   AND t1.NUM_EXP = ?   AND t1.REQ_FECHA = ?  ";

		List<VdesestimadosOs2> vdesestimadosos2List = this.jdbcTemplate.query(
				query, this.rwMap, vdesestimadosos2.getAnoExp(),
				vdesestimadosos2.getTerritExp(), vdesestimadosos2.getNumExp(),
				vdesestimadosos2.getReqFecha());
		return (VdesestimadosOs2) DataAccessUtils
				.uniqueResult(vdesestimadosos2List);
	}

	/**
	 * Removes a single row in the VdesestimadosOs2 table.
	 * 
	 * vdesestimadosos2 VdesestimadosOs2
	 *
	 * @param vdesestimadosos2
	 *            the vdesestimadosos 2
	 */
	public void remove(VdesestimadosOs2 vdesestimadosos2) {
		String query = "DELETE FROM VDESESTIMADOS_OS2 WHERE ANO_EXP=? AND TERRIT_EXP=? AND NUM_EXP=? AND REQ_FECHA=?";
		this.jdbcTemplate.update(query, vdesestimadosos2.getAnoExp(),
				vdesestimadosos2.getTerritExp(), vdesestimadosos2.getNumExp(),
				vdesestimadosos2.getReqFecha());
	}

	/**
	 * Finds a list of rows in the VdesestimadosOs2 table.
	 * 
	 * vdesestimadosos2 VdesestimadosOs2 jqGridRequestDto JQGridRequestDto List
	 * <VdesestimadosOs2>
	 *
	 * @param vdesestimadosos2
	 *            the vdesestimadosos 2
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VdesestimadosOs2> findAll(VdesestimadosOs2 vdesestimadosos2,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ANO_EXP ANOEXP,t1.TERRIT_EXP TERRITEXP,t1.NUM_EXP NUMEXP,t1.REQ_FECHA REQFECHA ");
		query.append("FROM VDESESTIMADOS_OS2 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vdesestimadosos2);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VdesestimadosOs2>) this.jdbcTemplate
				.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the VdesestimadosOs2 table using like.
	 * 
	 * vdesestimadosos2 VdesestimadosOs2 jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean List<VdesestimadosOs2>
	 *
	 * @param vdesestimadosos2
	 *            the vdesestimadosos 2
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VdesestimadosOs2> findAllLike(VdesestimadosOs2 vdesestimadosos2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ANOOS2_060 ANOEXP,t1.TEROS2_060 TERRITEXP,t1.NUMOS2_060 NUMEXP,t1.FECREQ_060 REQFECHA ");
		query.append("FROM AB0460S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vdesestimadosos2,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE IND_BATCH_SUB_060=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VdesestimadosOs2>) this.jdbcTemplate
				.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the VdesestimadosOs2 table.
	 * 
	 * vdesestimadosos2 VdesestimadosOs2 Long
	 *
	 * @param vdesestimadosos2
	 *            the vdesestimadosos 2
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(VdesestimadosOs2 vdesestimadosos2) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VDESESTIMADOS_OS2 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vdesestimadosos2);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the VdesestimadosOs2 table using like.
	 * 
	 * vdesestimadosos2 VdesestimadosOs2 startsWith Boolean Long
	 *
	 * @param vdesestimadosos2
	 *            the vdesestimadosos 2
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(VdesestimadosOs2 vdesestimadosos2,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0460S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vdesestimadosos2,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE IND_BATCH_SUB_060=1  ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of VdesestimadosOs2 selected for rup_table.
	 * 
	 * vdesestimadosos2 VdesestimadosOs2 jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean List<TableRowDto<VdesestimadosOs2>>
	 *
	 * @param vdesestimadosos2
	 *            the vdesestimadosos 2
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VdesestimadosOs2>> reorderSelection(
			VdesestimadosOs2 vdesestimadosos2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ANO_EXP ANOEXP,t1.TERRIT_EXP TERRITEXP,t1.NUM_EXP NUMEXP,t1.REQ_FECHA REQFECHA ");
		// FROM
		query.append("FROM VDESESTIMADOS_OS2 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vdesestimadosos2,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, VdesestimadosOs2.class,
				filterParamList, "ANO_EXP,TERRIT_EXP,NUM_EXP,REQ_FECHA");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<VdesestimadosOs2>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 * filterParams VdesestimadosOs2 searchParams VdesestimadosOs2
	 * jqGridRequestDto JQGridRequestDto startsWith Boolean List<TableRowDto
	 * <VdesestimadosOs2>>
	 *
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VdesestimadosOs2>> search(
			VdesestimadosOs2 filterParams, VdesestimadosOs2 searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ANO_EXP ANOEXP,t1.TERRIT_EXP TERRITEXP,t1.NUM_EXP NUMEXP,t1.REQ_FECHA REQFECHA ");
		// FROM
		query.append("FROM VDESESTIMADOS_OS2 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams,
				startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, VdesestimadosOs2.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"ANO_EXP,TERRIT_EXP,NUM_EXP,REQ_FECHA");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<VdesestimadosOs2>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 * filtervdesestimadosos2 VdesestimadosOs2 jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean
	 *
	 * @param filtervdesestimadosos2
	 *            the filtervdesestimadosos 2
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	@Override
	public void removeMultiple(VdesestimadosOs2 filtervdesestimadosos2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ANO_EXP ANOEXP,t1.TERRIT_EXP TERRITEXP,t1.NUM_EXP NUMEXP,t1.REQ_FECHA REQFECHA ");
		// FROM
		query.append("FROM VDESESTIMADOS_OS2 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this
				.getWhereLikeMap(filtervdesestimadosos2, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto,
						VdesestimadosOs2.class, query, params,
						"ANO_EXP,TERRIT_EXP,NUM_EXP,REQ_FECHA");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical VdesestimadosOs2 table.
	 * 
	 * filterVdesestimadosOs2 VdesestimadosOs2 jqGridRequestDto JQGridRequestDto
	 * List<JerarquiaDto<VdesestimadosOs2>>
	 *
	 * @param filterVdesestimadosOs2
	 *            the filter vdesestimados os 2
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Override
	public List<JerarquiaDto<VdesestimadosOs2>> findAllLikeJerarquia(
			VdesestimadosOs2 filterVdesestimadosOs2,
			JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ANO_EXP ANOEXP,t1.TERRIT_EXP TERRITEXP,t1.NUM_EXP NUMEXP,t1.REQ_FECHA REQFECHA ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM VDESESTIMADOS_OS2 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("VDESESTIMADOS_OS2");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterVdesestimadosOs2,
				false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "ANO_EXP,TERRIT_EXP,NUM_EXP,REQ_FECHA", "ID_PADRE",
				"NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy.
	 * 
	 * filterVdesestimadosOs2 VdesestimadosOs2 jqGridRequestDto JQGridRequestDto
	 * Long
	 *
	 * @param filterVdesestimadosOs2
	 *            the filter vdesestimados os 2
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the long
	 */
	@Override
	public Long findAllLikeCountJerarquia(
			VdesestimadosOs2 filterVdesestimadosOs2,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM VDESESTIMADOS_OS2 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("VDESESTIMADOS_OS2");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterVdesestimadosOs2,
				false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere,
				"ANO_EXP,TERRIT_EXP,NUM_EXP,REQ_FECHA", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows.
	 * 
	 * filterVdesestimadosOs2 VdesestimadosOs2 jqGridRequestDto JQGridRequestDto
	 * List<TableRowDto<VdesestimadosOs2>>
	 *
	 * @param filterVdesestimadosOs2
	 *            the filter vdesestimados os 2
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VdesestimadosOs2>> findAllChild(
			VdesestimadosOs2 filterVdesestimadosOs2,
			JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM VDESESTIMADOS_OS2 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("VDESESTIMADOS_OS2");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterVdesestimadosOs2,
				false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere,
				"ANO_EXP,TERRIT_EXP,NUM_EXP,REQ_FECHA", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<VdesestimadosOs2>(this.rwMapPK,
						"ANO_EXP,TERRIT_EXP,NUM_EXP,REQ_FECHA"),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VdesestimadosOs2 entity.
	 * 
	 * vdesestimadosos2 VdesestimadosOs2 Bean with the criteria values to filter
	 * by. Map created with two keys key query stores the sql query syntax key
	 * params stores the parameter values to be used in the condition sentence.
	 *
	 * @param vdesestimadosos2
	 *            the vdesestimadosos 2
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(VdesestimadosOs2 vdesestimadosos2) {

		StringBuilder where = new StringBuilder(
				VdesestimadosOs2DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vdesestimadosos2 != null && vdesestimadosos2.getAnoExp() != null) {
			where.append(" AND t1.ANO_EXP = ?");
			params.add(vdesestimadosos2.getAnoExp());
		}
		if (vdesestimadosos2 != null
				&& vdesestimadosos2.getTerritExp() != null) {
			where.append(" AND t1.TERRIT_EXP = ?");
			params.add(vdesestimadosos2.getTerritExp());
		}
		if (vdesestimadosos2 != null && vdesestimadosos2.getNumExp() != null) {
			where.append(" AND t1.NUM_EXP = ?");
			params.add(vdesestimadosos2.getNumExp());
		}
		if (vdesestimadosos2 != null
				&& vdesestimadosos2.getReqFecha() != null) {
			where.append(" AND t1.REQ_FECHA = ?");
			params.add(vdesestimadosos2.getReqFecha());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VdesestimadosOs2 entity.
	 * 
	 * vdesestimadosos2 VdesestimadosOs2 Bean with the criteria values to filter
	 * by. startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 *
	 * @param vdesestimadosos2
	 *            the vdesestimadosos 2
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(
			VdesestimadosOs2 vdesestimadosos2, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				VdesestimadosOs2DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vdesestimadosos2 != null && vdesestimadosos2.getAnoExp() != null) {
			where.append(" AND UPPER(t1.ANOOS2_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdesestimadosos2.getAnoExp().toUpperCase() + "%");
			} else {
				params.add(
						"%" + vdesestimadosos2.getAnoExp().toUpperCase() + "%");
			}
			where.append(" AND t1.ANOOS2_060 IS NOT NULL");
		}
		if (vdesestimadosos2 != null
				&& vdesestimadosos2.getTerritExp() != null) {
			where.append(" AND UPPER(t1.TEROS2_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdesestimadosos2.getTerritExp().toUpperCase() + "%");
			} else {
				params.add("%" + vdesestimadosos2.getTerritExp().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TEROS2_060 IS NOT NULL");
		}
		if (vdesestimadosos2 != null
				&& vdesestimadosos2.getNumExpDesde() != null) {
			where.append(" AND t1.NUMOS2_060 >= ?");
			params.add(vdesestimadosos2.getNumExpDesde());
		}
		if (vdesestimadosos2 != null
				&& vdesestimadosos2.getNumExpHasta() != null) {
			where.append(" AND t1.NUMOS2_060 <= ?");
			params.add(vdesestimadosos2.getNumExpHasta());
		}
		if (vdesestimadosos2 != null && vdesestimadosos2.getNumExp() != null) {
			where.append(" AND t1.NUMOS2_060 = ?");
			params.add(vdesestimadosos2.getNumExp());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
